define(['authentication_service'], function () {
    'use strict';

    describe('Authentication Service --', function () {
        var $scope,
            $http,
            $httpBackend,
            $q,
            $window,
            $location,
            $injector,
            service,
            localResourceDirectory,
            localResourceDirectoryServiceMock,
            patientFHIRService,
            patientFHIRServiceMock,
            localDeferred,
            pageServiceMock,
            windowOpenSpy;

        beforeEach(function() {
            module('angularTemplateApp');

            localResourceDirectoryServiceMock = jasmine.createSpyObj('localResourceDirectory', ['fetch']);
            pageServiceMock = jasmine.createSpyObj('pageService', ['warnLaunchpadNotInstalled']);
            patientFHIRServiceMock = jasmine.createSpyObj('patientFHIRService', ['setPatientContext']);

            // resourceDirectory returns a hash of keys to URL values for resource endpoints
            localResourceDirectory = {
                'users-logout' : '/users-logout',
                'users-login'  : '/users-login'
            };

            module(function($provide) {
                $provide.value('localResourceDirectoryService', localResourceDirectoryServiceMock);
                $provide.value('pageService', pageServiceMock);
                $provide.value('PatientFHIRService', patientFHIRServiceMock);
            });

            inject(function($rootScope, _$http_, _$httpBackend_, _$q_, _$window_, _$location_, _$injector_, authenticationService, PatientFHIRService) {
                $scope = $rootScope;
                $q = _$q_;
                $window = _$window_;
                $location = _$location_;
                $injector = _$injector_;
                patientFHIRService = PatientFHIRService;
                service = authenticationService;

                var resourceDeferred = $q.defer();
                resourceDeferred.resolve(localResourceDirectory);
                localResourceDirectoryServiceMock.fetch.and.returnValue(resourceDeferred.promise);
            });
        });

        describe('the service', function () {
            var cookieName = 'DNS      ';

            document.cookie = cookieName + 'REDACTED';

            beforeEach(function () {
                windowOpenSpy = spyOn(window, 'open');

                localDeferred = $q.defer();
                localDeferred.resolve('success'); // general resolved/success promise
            });

            it('should have some commonly used methods defined', function () {
                expect(service.authorize).toBeDefined();
                expect(service.authenticate).toBeDefined();
                expect(service.deleteCookie).toBeDefined();
                expect(service.gotoLogoutWithRedirect).toBeDefined();
                expect(service.gotoLoginWithRedirect).toBeDefined();
                expect(service.checkAuthStatus).toBeDefined();
                expect(service.isAuthenticated).toBeDefined();
                expect(service.checkJwtToken).toBeDefined();
            });

            it('should return true if user is authenticated', function () {
                service.isAuthenticated = true;

                expect(service.isAuthenticated).toEqual(true);
            });

            it('should return false if user is not authenticated', function () {
                service.isAuthenticated = false;

                expect(service.isAuthenticated).toEqual(false);
            });

            it('should call authorize if user is not authenticated', function () {
                spyOn(service, 'isAuthenticated').and.returnValue(false);
                spyOn(service, 'authorize');
                service.authenticate();

                expect(service.authorize).toHaveBeenCalled();
            });

            it('should logout and redirect to launchpad', function () {
                service.gotoLogoutWithRedirect();

                expect(localResourceDirectoryServiceMock.fetch).toHaveBeenCalled();
            });

            it('should get Jwt expiration', function () {
                var tokenData = {};
                tokenData = service.getParsedToken();
                expect(tokenData.exp).toEqual(1498509293);
            });
        });

        describe('checkAuthStatus Function', function () {
            var returnValue;

            beforeEach(function () {
                spyOn(service, 'checkJwtToken').and.returnValue({
                    then: function(cb) {
                        return cb(returnValue);
                    }
                });
            });

            it('should be a function', function () {
                expect(typeof(service.checkAuthStatus)).toEqual('function');
            });

            it('should check Jwt token', function () {
                service.checkAuthStatus();

                expect(service.checkJwtToken).toHaveBeenCalled();
            });
        });
    });
});
